org 100h

%define XRES 320
%define YRES 200
%define VESA_MODE 0x10e

;%define XRES 640
;%define YRES 480
;%define VESA_MODE 0x111

;%define XRES 1024
;%define YRES 768
;%define VESA_MODE 0x117

T1 equ -41*4 ; 65536/2pi / 256
T2 equ -28*4 ; 65536/2pi / 256 * ln(2)
T3 equ 59*4 ; 65536/2pi / 256 / ln(2)

C equ $+8
S_C equ $+12

; ds is moved: all  constant access is [ss:bp+?]
%define w(xx) word[byte bp+si-0x100+xx]
%define d(xx) dword[byte bp+si-0x100+xx]

  push 0xa000   ;<-[bp+si] points here
  lds bp,[si-3] ; bp=0, ds=0x6800  table: cos
  pop es              ; es=0xa000  screen
  mov ax,0x4f02
W equ $-1
  mov gs,ax           ; gs=0x4f02  table: 1 + 2*cos
  mov fs,w(W)         ; fs=0x8e4f  table: color_mul/cos
  mov bx,VESA_MODE
  int 10h    ; mode with 65536 colors

  add ax,0x39c9 ; 10 05 c9 39, should be "db 0f c9 39"
CTABLE equ $-4  ; 0.000383495197 ; = 2pi / 16384 ~ 1 / (256 * pi^2)

;Cos table with 16384 entries
  fninit
COS_TAB:
  imul bx,[bp+di],4 ; bx=[ss:bp+di]=[ss:-2]=angle (0 on init)
  fild word[bp+di]
  fmul d(CTABLE)
  fcos           ;; cos(angle/65536*2pi): adjust period to 2pi
  fst dword[bx]

  fld1
  fadd st1
  fadd st1
  fstp dword[gs:bx] ; 1 + 2*cos(...)

  fldl2e          ; color_mul = 1.44
  fdivrp st1,st0  ; color_mul / cos(...)
  fstp dword[fs:bx]
  inc word[bp+di] ; next angle
  jnz COS_TAB     ; bx=4
  
; Frame loop
M: ; bp=0 cx=timer
  dec cx  

  imul bx,cx,T2
  fld dword[bx]         ;; cos(t2)
  fidiv w(CZOOM)        ;; cos(t2)/zoom
  fld1
  fsubrp st1,st0        ;; scale=1-cos(t2)/zoom

  imul bx,cx,T1
  fmul dword[bx]        ;; C=cos(t)*scale
  fstp d(C)
  fld dword[bx-0x4000]  ;; sin(t)
  fdiv dword[bx]        ;; S_C=sin(t)/cos(t)
  fstp d(S_C)

; Pixel loop

X mov ax,0xcccd
  mul di
  add dx,0x9c80
  xchg ax,bx
  pusha ; [-18-16-14-12-10 -8 -6 -4]
        ;   di si bp sp bx dx cx ax 
        ;                  yy
        ;                x x
  mov ax,12         ; ax = number of iterations
CZOOM equ $-2
  cwd
  imul bx,cx,T3
  imul cx,cx,T2
  call IT
  popa

  pusha
  add di,di
  jnz NZDI
  mov ax,0x4f05  ; each line: set window, assume 64kB granularity
  cwd
  adc dx,dx
  xor bx,bx      ; bh=0 bl=window=0 dx=page
  int 10h  
NZDI:
  stosw
  popa
  inc di
  jnz X

  in al,60h ; ESC check
  cmp al,1
  jne M


LEN: ;; x y -> [bp+si] = sqrt(x*x+y*y)/65536/2 * 16384/2pi = sqrt(x*x+y*y)*C = sqrt(C2*(x*x+y*y))
  fld st1
  fmul st0
  fld st1
  fmul st0
  faddp
  fmul d(CTABLE)
  fsqrt
  fistp word[bp+si]
  ret


IT:
  ; [-18-16-14-12-10 -8 -6 -4]
  ;   di si bp sp bx dx cx ax 
  ;                  yy
  ;                x x

  fldz
  fldz
  fldz       ; R=0 G=0 B=0

MP:
  fild word[bp-8]
  fadd st0

  fild word[bp-9]  ;; x[-3.32..3.32*32768] y[-2..2*32768] R G B
  fadd st0

  call LEN
  imul di,[bp+si],4 ; di = d = 65536/2pi * length(x,y)/2
  sub cx,di         ; cx = t2-d
  add di,bx         ; di = d-t3

I:
; rotate and scale, square fold
  ;[x] = [C -S]*[x]
  ;[y]   [S  C] [y]
R fld st1         ;; y x y R G B    | x Sy x Cy R G B
  
  fistp dword[bp+si]
  xor word[bp+si],0x8000
  fild word[bp+si]
  
  fmul d(C)       ;; Cy x y R G B   | Cx Sy x Cy R G B
  fst st2         ;; Cy x Cy R G B  | Cx Sy Cx Cy R G B
  fmul d(S_C)     ;; Sy x Cy R G B  | Sx Sy Cx Cy R G B
  neg al
  js R
  faddp st3,st0  ;; Sy Cx Sx+Cy R G B
  fsubp st1,st0  ;; x=Cx-Sy y=Sx+Cy R G B

; interfering concentric circles
  call LEN
  imul bx,[bp+si],10*4 ; 65536/2pi * 5*length(x,y)
  fld dword[fs:bx+di] ;; k=color_mul/cos(5*length(x,y) + d - t3) x y R G B
  fld st0
  fld st0             ;; k k k x y R G B

; RGB += k * ( 0.5 + cos(3*(t2 - d + i/100) + [0 -1 -2]) );
  imul bx,ax,26*4     ; bx = q = 65536/2pi * (i/100
  add bx,cx           ;                       +t2-d
  imul bx,3           ;                      ) * 3

G fmul dword[gs:bx] ;; k*(1+2cos(q)) k k x y R G B
  faddp st5,st0     ;; k k x y R+=k*(1+2cos(q)) G B
  sub bh,40   ; ~ 256/2pi
  add al,0x55       ;; x y [R G B]+=k*(1+2cos(q+[0 -1 -2]))
  jnc G         ; al--
  jnz I

  fcompp            ;; R G B

  mov cl,5      ; shift length: cycle 5,6,5
COL:
  fmul st0          ;; R^2 G^2 B^2
  fistp word[bp+si] ; if it's > 0x7fff, store 0x8000
  imul bx,[bp+si],2 ; double, set carry if it was > 0x3fff
  sbb bx,bp         ; overflow -> 0xffff
  shld [bp-4],bx,cl ; rrrrrggggggbbbbb
  xor cl,5^6
  inc si
  jpo COL ; loop 3x

  ret
